//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Timers;

namespace FrameworkLibraries
{
	public class TimerMain 
	{
		private static long lastTickCount = 0;
		public static void OnElapsedEvent(object source, ElapsedEventArgs e)
		{
			if(lastTickCount == 0)
			{
				lastTickCount = Environment.TickCount;
				Console.WriteLine("Witaj!!");
			}
			else
			{
				long currentTickCount = Environment.TickCount;
				Console.WriteLine("Witaj!! {0}", currentTickCount - lastTickCount);
				lastTickCount = currentTickCount;
			}
		}
		static void Main(string [] args)
		{
			Timer timer = new Timer();
			timer.Elapsed+=new ElapsedEventHandler(OnElapsedEvent);
			// Ustawienie interwau na 1 sekund.
			timer.Interval = 1000;
			timer.Enabled = true;
 
			Console.WriteLine("Wcinij <enter>, aby opuci program.");
			Console.ReadLine();
		}
	}
}
